<?php
require_once '../Database.php';

class HistoryController
{
    private $db;

    public function __construct()
    {
        $this->db = Database::getInstance();
    }

    /*public function getAllHistory()
    {
        try {
            $sql = "SELECT h.*, COALESCE(u.user_name, '') as user_name, COALESCE(o.timestamp, '0') as order_timestamp, COALESCE(o.total_price, '0') as total_price FROM history h LEFT JOIN users u ON u.user_code = h.user_code LEFT JOIN orders o ON o.order_code = h.order_code;";
            $stmt = $this->db->prepare($sql);
            $stmt->execute();
            return $stmt->fetchAll(PDO::FETCH_ASSOC);
        } catch (Exception $e) {
            $message = $e->getMessage();
            $data = [
                'message' => $message
            ];
            return $data;
        }
    }*/

    public function getAllHistory()
    {
        try {
            $sql = "SELECT timestamp, JSON_ARRAYAGG(JSON_OBJECT('product_code', product_code, 'model_name', model_name, 'color_code', color_code, 'count', total_count)) AS products FROM (SELECT timestamp, product_code, model_name, color_code, SUM(count) AS total_count FROM history GROUP BY timestamp, product_code, model_name) AS aggregated_data GROUP BY timestamp ORDER BY timestamp;";

            $stmt = $this->db->prepare($sql);
            $stmt->execute();
            return $stmt->fetchAll(PDO::FETCH_ASSOC);
        } catch (Exception $e) {
            $message = $e->getMessage();
            $data = [
                'message' => $message
            ];
            return $data;
        }
    }

    /*public function insertHistory($product_code, $model_name, $color_code, $count, $state, $timestamp, $user_code)
    {
        $sql = "INSERT INTO history (product_code,model_name,color_code, count,state,timestamp,user_code) VALUES 
                                                                                        ('$product_code',
                                                                                         '$model_name',
                                                                                         '$color_code',
                                                                                         '$count',
                                                                                         '$state',
                                                                                         '$timestamp',
                                                                                         '$user_code')";

        try {
            $stmt = $this->db->query($sql);
            if ($stmt) {
                $message = "ok";
            }
        } catch (Exception $e) {
            $message = $e->getMessage();
        }

        $data = [
            'message' => $message
        ];
        return $data;
    }*/

    public function insertHistoryImport($product_code, $model_name, $color_code, $count, $state, $timestamp, $user_code)
    {
        if ($timestamp == 0) {
            $message = "ok";
        } else {
            if ($state == -1) {
                $sql = "INSERT INTO history (product_code,model_name,color_code, count,state,timestamp,user_code) VALUES 
                                                                                        ('$product_code',
                                                                                         '$model_name',
                                                                                         '$color_code',
                                                                                         '$count',
                                                                                         '$state',
                                                                                         '$timestamp',
                                                                                         '$user_code') ON DUPLICATE KEY UPDATE count = count - $count";
            } else if ($state == 0) {
                $sql = "INSERT INTO history (product_code,model_name,color_code, count,state,timestamp,user_code) VALUES 
                                                                                        ('$product_code',
                                                                                         '$model_name',
                                                                                         '$color_code',
                                                                                         '$count',
                                                                                         '$state',
                                                                                         '$timestamp',
                                                                                         '$user_code') ON DUPLICATE KEY UPDATE count = count + $count";
            }

            try {
                $stmt = $this->db->query($sql);
                if ($stmt) {
                    $message = "ok";
                }
            } catch (Exception $e) {
                $message = $e->getMessage();
            }
        }

        $data = [
            'message' => $message
        ];
        return $data;
    }

    public function insertHistoryOrder($product_code, $model_name, $color_code, $count, $state, $timestamp, $user_code, $order_code, $orders, $customer_name, $customer_code)
    {
        if ($state > 0) {
            $sql = "INSERT INTO history (product_code,model_name,color_code, count,state,timestamp,user_code,order_code, orders, customer_name, customer_code) VALUES 
                                                                                        ('$product_code',
                                                                                         '$model_name',
                                                                                         '$color_code',
                                                                                         '$count',
                                                                                         '$state',
                                                                                         '$timestamp',
                                                                                         '$user_code',
                                                                                         '$order_code', 
                                                                                         '$orders', 
                                                                                         '$customer_name', 
                                                                                         '$customer_code')";
        }

        try {
            $stmt = $this->db->query($sql);
            if ($stmt) {
                $message = "ok";
            }
        } catch (Exception $e) {
            $message = $e->getMessage();
        }

        $data = [
            'message' => $message
        ];
        return $data;
    }
}