<?php
require_once '../Database.php';

class HistoryController
{
    private $db;

    public function __construct()
    {
        $this->db = Database::getInstance();
    }

    public function getAllHistory()
    {
        try {
            $sql = "SELECT h.*, COALESCE(u.user_name, '') as user_name, COALESCE(o.timestamp, '0') as order_timestamp, COALESCE(o.total_price, '0') as total_price FROM history h LEFT JOIN users u ON u.user_code = h.user_code LEFT JOIN orders o ON o.order_code = h.order_code;";
            $stmt = $this->db->prepare($sql);
            //$stmt->bindParam(':user_code', $user_code);
            $stmt->execute();
            return $stmt->fetchAll(PDO::FETCH_ASSOC);
        } catch (Exception $e) {
            $message = $e->getMessage();
            $data = [
                'message' => $message
            ];
            return $data;
        }
    }

    public function insertHistory($product_code, $model_name, $color_code, $count, $state, $timestamp, $user_code)
    {
        $sql = "INSERT INTO history (product_code,model_name,color_code, count,state,timestamp,user_code) VALUES 
                                                                                        ('$product_code',
                                                                                         '$model_name',
                                                                                         '$color_code',
                                                                                         '$count',
                                                                                         '$state',
                                                                                         '$timestamp',
                                                                                         '$user_code')";

        try {
            $stmt = $this->db->query($sql);
            if ($stmt) {
                $message = "ok";
            }
        } catch (Exception $e) {
            $message = $e->getMessage();
        }

        $data = [
            'message' => $message
        ];
        return $data;
    }
}