<?php
require_once '../Database.php';
include '../Controller/ProductController.php';
require_once '../Model/ModelReleasedOrders.php';
class OrderController
{
    private $db;
    public function __construct()
    {
        $this->db = Database::getInstance();
    }

    public function getReleasedOrders($user_code)
    {
        if (500 < $user_code && $user_code < 600) {
            $sql = "SELECT * FROM customers WHERE customer_code = '$user_code'";
            $stmt = $this->db->query($sql);
            $row = $stmt->fetch(PDO::FETCH_ASSOC);
            if ($row) {
                $customer_code = $row['customer_code'];
                $sql = "SELECT * FROM orders WHERE customer_code = '$customer_code'";
            }
        } else {
            $sql = "SELECT * FROM orders";
        }
        $stmt = $this->db->query($sql);
        $row = $stmt->fetchAll();

        $releasedOrdersObject = [];
        
        foreach ($row as $order_item) {
            $order_code = (int) $order_item['order_code'];
            $orders = $order_item['orders'];
            $released_orders = $order_item['released_orders'];
            $customer_name = $order_item['customer_name'];
            $customer_code =  (int) $order_item['customer_code'];
            $register_timestamp = (int) $order_item['timestamp'];
            
            
            $subOrdersJson = json_decode($orders, true);
            $releasedOrdersJson = json_decode($released_orders, true);
            
            if ($releasedOrdersJson == null) {
                continue;
            }

            foreach ($releasedOrdersJson as &$item_release) {
                $release_timestamp = $item_release['timestamp'];
                $factor_code = $item_release['factor_code'];
                $release_orders = $item_release['release_order'];
                $modelReleasedOrders = new ModelReleasedOrders();
                $modelReleasedOrders->factor_code = $factor_code;
                $modelReleasedOrders->customer_code = $customer_code;
                $modelReleasedOrders->customer_name = $customer_name;
                $modelReleasedOrders->order_code = $order_code;
                $modelReleasedOrders->register_timestamp = $register_timestamp;
                $modelReleasedOrders->release_timestamp = $release_timestamp;

                foreach ($release_orders as $item_release_order) {
                    $product_code = $item_release_order['product_code'];
                    $model_name = $item_release_order['model_name'];
                    $color_code = $item_release_order['color_code'];
                    $count = $item_release_order['count'];
                    $price = $item_release_order['price'];

                    $releasedOrder1 = new ReleasedOrders();
                    $releasedOrder1->model_name = $model_name;
                    $releasedOrder1->color_code = $color_code;
                    $releasedOrder1->product_code = $product_code;
                    $releasedOrder1->count = $count;
                    $releasedOrder1->price = $price;
                    $releasedOrder1->total_price = $count * $price;

                    $modelReleasedOrders->releasedOrdersList[] = $releasedOrder1;
                }

                $releasedOrdersObject[] = $modelReleasedOrders;
            }
        }
        //$jsonData = json_encode($releasedOrdersObject, JSON_UNESCAPED_UNICODE);
        

        return $releasedOrdersObject;
    }

    public function getAllOrders($user_code)
    {
        try {
            if (500 < $user_code && $user_code < 600) {
                $sql = "SELECT * FROM customers WHERE customer_code = '$user_code'";
                $stmt = $this->db->query($sql);
                $row = $stmt->fetch(PDO::FETCH_ASSOC);
                if ($row) {
                    $customer_code = $row['customer_code'];
                    $stmt = $this->db->prepare("SELECT * FROM orders WHERE customer_code = '$customer_code'");
                }
            } else {
                $stmt = $this->db->prepare("SELECT * FROM orders");
            }
            $stmt->execute();
            return $stmt->fetchAll(PDO::FETCH_ASSOC);
        } catch (Exception $e) {
            $message = $e->getMessage();
            $data = [
                'message' => $message
            ];
            return $data;
        }
    }

    public function getAllOrdersByState($state, $user_code)
    {
        try {
            if (500 < $user_code && $user_code < 600) {
                $sql = "SELECT * FROM customers WHERE customer_code = '$user_code'";
                $stmt = $this->db->query($sql);
                $row = $stmt->fetch(PDO::FETCH_ASSOC);
                if ($row) {
                    $customer_code = $row['customer_code'];
                    $stmt = $this->db->prepare("SELECT * FROM orders WHERE state = '$state' AND customer_code = '$customer_code'");
                }
            } else {
                $stmt = $this->db->prepare("SELECT * FROM orders WHERE state = '$state'");
            }

            $stmt->execute();
            return $stmt->fetchAll(PDO::FETCH_ASSOC);
        } catch (Exception $e) {
            $message = $e->getMessage();
            $data = [
                'message' => $message
            ];
            return $data;
        }
    }

    public function insertOrder($order_code, $customer_name, $customer_code, $orders, $description)
    {
        $total_price = 0;
        $subOrdersJson = json_decode($orders, true);
        foreach ($subOrdersJson as $item) {
            $price = $item['price'];
            $count = $item['count'];
            //$total_item_price = $price * $count;
            $total_item_price = $item['total_price'];
            $total_price = $total_price + $total_item_price;
        }
        $timestamp = round(microtime(true) * 1000);
        $sql = "INSERT INTO orders (order_code,customer_name, customer_code, orders, description, timestamp, total_price) VALUES ('$order_code', '$customer_name', '$customer_code','$orders', '$description', '$timestamp','$total_price')";
        try {
            $stmt = $this->db->query($sql);
            if ($stmt) {
                $message = "ok";
            }
        } catch (Exception $e) {
            $message = $e->getMessage();
        }

        $data = [
            'message' => $message
        ];
        return $data;
    }

    public function updateOrdersById($id, $order_code, $customer_name, $customer_code, $orders, $remain_orders, $state, $timestamp)
    {
        try {
            $sql = "UPDATE orders SET order_code = '$order_code', customer_name = '$customer_name', customer_code = '$customer_code', orders = '$orders', remain_orders = '$remain_orders', state = '$state', timestamp = '$timestamp' WHERE id = '$id'";
            $stmt = $this->db->query($sql);
            if ($stmt) {
                $message = "ok";
            }
        } catch (Exception $e) {
            $message = $e->getMessage();
        }

        $data = [
            'message' => $message
        ];
        return $data;
    }

    public function updateOrder($id, $orders)
    {
        $sql = "UPDATE orders SET orders = '$orders' WHERE id = '$id'";

        try {
            $stmt = $this->db->query($sql);
            if ($stmt) {
                $message = "ok";
            }
        } catch (Exception $e) {
            $message = $e->getMessage();
        }

        $data = [
            'message' => $message
        ];
        return $data;
    }

    public function releaseOrder($id, $factor_code, $user_code)
    {
        $sql = "SELECT * FROM orders WHERE id = $id";
        try {
            $stmt = $this->db->query($sql);

            $row = $stmt->fetch(PDO::FETCH_ASSOC);

            if ($row) {
                $order_code = $row['order_code'];
                $orders = $row['orders'];
                $released_orders = $row['released_orders'];
                $customer_name = $row['customer_name'];
                $customer_code = $row['customer_code'];

                $subOrdersJson = json_decode($orders, true);
                $subReleasedOrdersJson = [];

                foreach ($subOrdersJson as &$item) {
                    $product_code = $item['product_code'];
                    $model_name = $item['model_name'];
                    $color_code = $item['color_code'];
                    $standbyCount = $item['standby'];
                    $count = $item['count'];
                    if ($standbyCount > 0) {
                        $sql = "UPDATE products SET standby = 0, count = count - $standbyCount WHERE product_code = '$product_code'";
                        $stmt = $this->db->query($sql);
                        if (!$stmt) {
                            $message = "break";
                            break;
                        }

                        $item['released'] += $standbyCount;
                        $item['standby'] = 0;

                        $subReleaseData = [
                            "count" => $standbyCount,
                            "price" => $item['price'],
                            "product_code" => $product_code,
                            "model_name" => $model_name,
                            "color_code" => $color_code
                        ];

                        $subReleasedOrdersJson[] = $subReleaseData;
                    }
                }

                if (is_array($subReleasedOrdersJson) && empty($subReleasedOrdersJson)) {
                    $message = "break";
                }

                $newSubOrdersJson = json_encode($subOrdersJson, JSON_UNESCAPED_UNICODE);

                $timestamp = round(microtime(true) * 1000);
                $releaseOrderItem = [
                    "factor_code" => (int)$factor_code,
                    "release_order" => $subReleasedOrdersJson,
                    "timestamp" => $timestamp
                ];


                $releasedOrdersJson = json_decode($released_orders, true);
                $releasedOrdersJson[] = $releaseOrderItem;
                $updatedReleaseJsonArray = json_encode($releasedOrdersJson, JSON_UNESCAPED_UNICODE);

                if ($message != "break") {
                    $count = 0;
                    $released = 0;

                    foreach ($subOrdersJson as &$item) {
                        $count += $item['count'];
                        $released += $item['released'];
                    }

                    if ($count == $released) {
                        $complete_timestamp = round(microtime(true) * 1000);
                        $sql = "UPDATE orders SET orders = '$newSubOrdersJson', released_orders = '$updatedReleaseJsonArray', state = 2, complete_timestamp = $complete_timestamp WHERE id = $id";
                        $stmt = $this->db->query($sql);
                        if ($stmt) {
                            $sql = "INSERT INTO history (state, timestamp, user_code, order_code, orders, customer_name, customer_code) VALUES 
                                                                                          (2,
                                                                                            '$complete_timestamp',
                                                                                            '$user_code',
                                                                                            '$order_code',
                                                                                            '$orders',
                                                                                            '$customer_name',
                                                                                            '$customer_code')";
                            $stmt = $this->db->query($sql);
                            if ($stmt) {
                                $message = "completed";
                            }
                        }
                    } else {
                        //$sql = "UPDATE orders SET orders = '$newSubOrdersJson', released_orders = '$updatedReleaseJsonArray', state = 1 WHERE id = '$id'";
                        $sql = "UPDATE orders SET orders = '$newSubOrdersJson', released_orders = '$updatedReleaseJsonArray' WHERE id = '$id'";
                        $stmt = $this->db->query($sql);
                        if ($stmt) {
                            $message = "released";
                        }
                    }
                }
            }
        } catch (Exception $e) {
            $message = $e->getMessage();
        }

        $data = [
            'message' => $message
        ];
        return $data;
    }

    public function completeOrder($id, $user_code) {
        $sql = "SELECT * FROM orders WHERE id = $id";
        try {
            $stmt = $this->db->query($sql);
            $row = $stmt->fetch(PDO::FETCH_ASSOC);
                
            if ($row) {
                $complete_timestamp = round(microtime(true) * 1000);
                $sql = "UPDATE orders SET state = 2, complete_timestamp = $complete_timestamp WHERE id = $id";
                $stmt = $this->db->query($sql);
                if ($stmt) {
                    $order_code = $row['order_code'];
                    $orders = $row['orders'];
                    $customer_name = $row['customer_name'];
                    $customer_code = $row['customer_code'];
                    $sql = "INSERT INTO history (state, timestamp, user_code, order_code, orders, customer_name, customer_code) VALUES 
                                                                                    (2,
                                                                                    '$complete_timestamp',
                                                                                    '$user_code',
                                                                                    '$order_code',
                                                                                    '$orders',
                                                                                    '$customer_name',
                                                                                    '$customer_code')";
                    $stmt = $this->db->query($sql);
                    if ($stmt) {
                        $message = "ok"; 
                    }
                            
                }
                
            }
        }
        catch (Exception $e) {
            $message = $e->getMessage();
        }

        $data = [
        'message' => $message
        ];
        return $data;
    }

    public function deleteOrder($id)
    {
        $sql = "SELECT orders FROM orders WHERE id = $id";
        try {
            $stmt = $this->db->query($sql);
            $subOrdersString = $stmt->fetchColumn();
            if ($subOrdersString) {
                $subOrdersJson = json_decode($subOrdersString, true);
                foreach ($subOrdersJson as $item) {
                    $product_code = $item['product_code'];
                    $standbyCount = $item['standby'];
                    $sql1 = "UPDATE products SET standby = standby - $standbyCount WHERE product_code = '$product_code'";
                    $stmt1 = $this->db->query($sql1);
                    if (!$stmt) {
                        $message = "break";
                        break;
                    }
                }
                if ($message != "break") {
                    $sql = "DELETE FROM orders WHERE id = $id";
                    $stmt = $this->db->query($sql);
                    if ($stmt) {
                        $message = "ok";
                    }
                }
            }
        } catch (Exception $e) {
            $message = $e->getMessage();
        }

        $data = [
            'message' => $message
        ];
        return $data;
    }
}