<?php
require_once '../Database.php';
class ProductController
{
    private $db;

    public function __construct()
    {
        $this->db = Database::getInstance();
    }

    public function getAllProducts()
    {
        try {
            $sql = "SELECT * FROM products ORDER BY model_name ASC, color_code ASC";
            $stmt = $this->db->prepare($sql);
            $stmt->execute();
            return $stmt->fetchAll(PDO::FETCH_ASSOC);
        } catch (Exception $e) {
            $message = $e->getMessage();
            $data = [
                'message' => $message
            ];
            return $data;
        }
    }

    public function getAllProductsByModel()
    {
        try {
            $sql = "SELECT DISTINCT p.color_code, m.model_name, m.model_code FROM products p JOIN models m ON p.model_name = m.model_name WHERE m.model_name IS NOT NULL";
            $stmt = $this->db->prepare($sql);
            $stmt->execute();
            return $stmt->fetchAll(PDO::FETCH_ASSOC);
        } catch (Exception $e) {
            $message = $e->getMessage();
            $data = [
                'message' => $message
            ];
            return $data;
        }
    }

    public function getAllProductsByFilter($grade, $shine)
    {
        try {
            if ($shine == -1) {
                $sql = "SELECT * FROM products WHERE grade = '$grade' ORDER BY model_name ASC, color_code ASC";
            } else if ($grade == -1) {
                $sql = "SELECT * FROM products WHERE shine = '$shine' ORDER BY model_name ASC, color_code ASC";
            } else {
                $sql = "SELECT * FROM products WHERE grade = '$grade' AND shine = '$shine' ORDER BY model_name ASC, color_code ASC";
            }
            $stmt = $this->db->prepare($sql);
            $stmt->execute();
            return $stmt->fetchAll(PDO::FETCH_ASSOC);
        } catch (Exception $e) {
            $message = $e->getMessage();
            $data = [
                'message' => $message
            ];
            return $data;
        }
    }

    public function getProduct($product_code)
    {
        try {
            $stmt = $this->db->prepare("SELECT * FROM products WHERE product_code = :product_code");
            $stmt->bindParam(':product_code', $product_code);
            $stmt->execute();
            return $stmt->fetchAll(PDO::FETCH_ASSOC);
        } catch (Exception $e) {
            $message = $e->getMessage();
            $data = [
                message => $message
            ];
            return $data;
        }
    }

    public function insertProduct($model_name, $model_code, $color_name, $color_code, $price)
    {

        $combined_string1 = (string)$model_code . (string)$color_code . "1" . "1";
        $product_code_grade1 = (int) $combined_string1;

        $combined_string2 = (string)$model_code . (string)$color_code . "1" . "2";
        $product_code_grade2 = (int) $combined_string2;

        $combined_string3 = (string)$model_code . (string)$color_code . "1" . "3";
        $product_code_grade3 = (int) $combined_string3;

        $combined_string4 = (string)$model_code . (string)$color_code . "2" . "1";
        $product_code_grade4 = (int) $combined_string4;

        $combined_string5 = (string)$model_code . (string)$color_code . "2" . "2";
        $product_code_grade5 = (int) $combined_string5;

        $combined_string6 = (string)$model_code . (string)$color_code . "2" . "3";
        $product_code_grade6 = (int) $combined_string6;

        $sql1 = "INSERT INTO products (product_code, model_name,model_code,color_name,color_code,price, grade, shine) VALUES ('$product_code_grade1', '$model_name', '$model_code', '$color_name', '$color_code', '$price', 1, 1)";
        $sql2 = "INSERT INTO products (product_code, model_name,model_code,color_name,color_code,price, grade, shine) VALUES ('$product_code_grade2', '$model_name', '$model_code', '$color_name', '$color_code', '$price', 2, 1)";
        $sql3 = "INSERT INTO products (product_code, model_name,model_code,color_name,color_code,price, grade, shine) VALUES ('$product_code_grade3', '$model_name', '$model_code', '$color_name', '$color_code', '$price', 3, 1)";
        $sql4 = "INSERT INTO products (product_code, model_name,model_code,color_name,color_code,price, grade, shine) VALUES ('$product_code_grade4', '$model_name', '$model_code', '$color_name', '$color_code', '$price', 1, 2)";
        $sql5 = "INSERT INTO products (product_code, model_name,model_code,color_name,color_code,price, grade, shine) VALUES ('$product_code_grade5', '$model_name', '$model_code', '$color_name', '$color_code', '$price', 2, 2)";
        $sql6 = "INSERT INTO products (product_code, model_name,model_code,color_name,color_code,price, grade, shine) VALUES ('$product_code_grade6', '$model_name', '$model_code', '$color_name', '$color_code', '$price', 3, 2)";

        try {
            $stmt1 = $this->db->query($sql1);
            $stmt2 = $this->db->query($sql2);
            $stmt3 = $this->db->query($sql3);
            $stmt4 = $this->db->query($sql4);
            $stmt5 = $this->db->query($sql5);
            $stmt6 = $this->db->query($sql6);
            if ($stmt1 && $stmt2 && $stmt3 && $stmt4 && $stmt5 && $stmt6) {
                $message = "ok";
            }
        } catch (Exception $e) {
            $message = $e->getMessage();
        }

        $data = [
            'message' => $message
        ];
        return $data;
    }

    public function updateProductById($id, $product_code, $model_name, $model_code, $color_name, $color_code, $price, $count)
    {
        $sql = "SELECT product_code from products WHERE id = '$id'";
        $stmt = $this->db->query($sql);
        $old_product_code = $stmt->fetchColumn();

        $total_price = $price * $count;
        $sql = "UPDATE products SET product_code = '$product_code', model_name = '$model_name', 
                    model_code = '$model_code', color_name = '$color_name', 
                    color_code = '$color_code', price = '$price', count = '$count', 
                    total_price = '$total_price' WHERE id = '$id'";

        try {
            $stmt = $this->db->query($sql);
            if ($stmt) {

                $sql = "SELECT id, orders FROM orders";
                $stmt = $this->db->query($sql);
                $records = $stmt->fetchAll(PDO::FETCH_ASSOC);

                foreach ($records as $record) {
                    $id  = $record['id'];
                    $orders  = $record['orders'];
                    $subOrdersJson = json_decode($orders, true);

                    foreach ($subOrdersJson as &$item) {
                        if ($item['product_code'] == $old_product_code) {
                            $item['product_code'] = $product_code;
                            $item['model_name'] = $model_name;
                            $item['color_code'] = $color_code;
                        }
                    }
                    $newOrders = json_encode($subOrdersJson, JSON_UNESCAPED_UNICODE);
                    $updateQuery = "UPDATE orders SET orders = '$newOrders' WHERE id = '$id'";
                    $stmt = $this->db->query($updateQuery);
                }

                $message = "ok";
            }
        } catch (Exception $e) {
            $message = $e->getMessage();
        }

        $data = [
            'message' => $message
        ];
        return $data;
    }

    public function updateProductImport($id, $new_count, $user_code, $timestamp, $import)
    {
        try {
            $sql = "SELECT * FROM products WHERE id = $id";
            $stmt = $this->db->query($sql);
            $row = $stmt->fetch(PDO::FETCH_ASSOC);
            if ($row) {
                $price = $row['price'];
                $total_price = $price * $count;
                $count = $row['count'];
                $standby = $row['standby'];
               
                if ($import == "true") {
                    $new_count = $count + $new_count;
                } else {
                    $free_count = $count - $standby;
                    $new_count = $count - $new_count;
                    echo $count."\n";
                    echo $free_count."\n";
                    echo $new_count."\n";
                    if ($new_count < 0 || $new_count < $standby) {
                        $data = [
                            'message' => "invalid_count"
                        ];
                        return $data;
                    }
                }

                $sql = "UPDATE products SET count = '$new_count', total_price = '$total_price' WHERE id = '$id'";
                $stmt = $this->db->query($sql);
                if ($stmt) {
                    if ($import) {
                        $product_code = $row['product_code'];
                        $model_name = $row['model_name'];
                        $color_code = $row['color_code'];
                        //$timestamp = round(microtime(true) * 1000);
                        $sql = "INSERT INTO history (product_code,model_name,color_code, count,state,timestamp, user_code) VALUES 
                                                                                            ('$product_code',
                                                                                             '$model_name',
                                                                                             '$color_code',
                                                                                             '$new_count',
                                                                                             '0',
                                                                                             '$timestamp',
                                                                                             '$user_code')";
                        $stmt = $this->db->query($sql);
                    }
                    if ($stmt) {
                        $message = "ok";
                    }
                }
            }
        } catch (Exception $e) {
            $message = $e->getMessage();
        }

        $data = [
            'message' => $message
        ];
        return $data;
    }

    public function updateProductStandby($id, $standby, $order_code, $user_code, $timestamp)
    {
        try {
            $sql = "SELECT * FROM products WHERE id = $id";

            $stmt = $this->db->query($sql);
            $row = $stmt->fetch(PDO::FETCH_ASSOC);
            if ($row) {
                $count = $row['count'];
                if ($standby > $count) {
                    $data = [
                        'message' => "invalid_count"
                    ];
                    return $data;
                }
                $sql = "UPDATE products SET standby = '$standby' WHERE id = '$id'";

                $stmt = $this->db->query($sql);
                if ($stmt) {

                    $product_code = $row['product_code'];
                    $model_name = $row['model_name'];
                    $color_code = $row['color_code'];

                    //$timestamp = round(microtime(true) * 1000);
                    $sql = "INSERT INTO history (product_code, model_name, color_code, count, state, timestamp, user_code, order_code) VALUES ('$product_code', '$model_name', '$color_code', '$standby', '1', '$timestamp', '$user_code', '$order_code')";
                    $stmt = $this->db->query($sql);
                    if ($stmt) {
                        $message = "ok";
                    }
                }
            }
        } catch (Exception $e) {
            $message = $e->getMessage();
        }

        $data = [
            'message' => $message
        ];
        return $data;
    }

    public function updateProductInStandbyByProductCode($product_code, $standby, $state)
    {
        $sql = "UPDATE products SET standby = standby - '$standby' WHERE product_code = '$product_code'";

        try {
            $stmt = $this->db->query($sql);
            if ($stmt) {
                $message = "ok";
            }
        } catch (Exception $e) {
            $message = $e->getMessage();
        }

        $data = [
            'message' => $message
        ];
        return $data;
    }

    public function deleteProductById($id)
    {
        $sql = "DELETE FROM products WHERE id = $id";

        try {
            $stmt = $this->db->query($sql);
            if ($stmt) {
                $message = "ok";
            }
        } catch (Exception $e) {
            $message = $e->getMessage();
        }

        $data = [
            'message' => $message
        ];
        return $data;
    }

    public function deleteProductByModel($model_code)
    {
        $sql = "DELETE FROM products WHERE model_code = $model_code";

        try {
            $stmt = $this->db->query($sql);
            if ($stmt) {
                $message = "ok";
            }
        } catch (Exception $e) {
            $message = $e->getMessage();
        }

        $data = [
            'message' => $message
        ];
        return $data;
    }

    public function deleteProduct($model_code, $color_code)
    {
        $sql = "DELETE FROM products WHERE model_code = $model_code AND color_code = $color_code";

        try {
            $stmt = $this->db->query($sql);
            if ($stmt) {
                $message = "ok";
            }
        } catch (Exception $e) {
            $message = $e->getMessage();
        }

        $data = [
            'message' => $message
        ];
        return $data;
    }
}
